<?php

namespace App\Events;

use App\Models\Juego;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BolaSorteada implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public array $bola;
    public int $bolasSorteadas;
    public int $maxBolas;
    public ?array $ganadorLinea;
    public ?array $ganadorBingo;
    public bool $finalizado;
    public bool $limiteAlcanzado;
    public float $acumulado;
    public float $premioLinea;
    public float $premioBingo;
    public string $estado;

    public function __construct(
        int $juegoId,
        array $bola,
        int $bolasSorteadas,
        int $maxBolas,
        ?array $ganadorLinea,
        ?array $ganadorBingo,
        bool $finalizado,
        bool $limiteAlcanzado,
        float $acumulado,
        float $premioLinea,
        float $premioBingo,
        string $estado
    ) {
        $this->juegoId = $juegoId;
        $this->bola = $bola;
        $this->bolasSorteadas = $bolasSorteadas;
        $this->maxBolas = $maxBolas;
        $this->ganadorLinea = $ganadorLinea;
        $this->ganadorBingo = $ganadorBingo;
        $this->finalizado = $finalizado;
        $this->limiteAlcanzado = $limiteAlcanzado;
        $this->acumulado = $acumulado;
        $this->premioLinea = $premioLinea;
        $this->premioBingo = $premioBingo;
        $this->estado = $estado;
    }

    public function broadcastOn(): array
    {
        return [
            new Channel('juego.' . $this->juegoId),
        ];
    }

    public function broadcastAs(): string
    {
        return 'bola.sorteada';
    }
}
