<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ConfiguracionActualizada implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public int $maxBolas;
    public string $mensaje;

    public function __construct(int $juegoId, int $maxBolas, string $mensaje = '')
    {
        $this->juegoId = $juegoId;
        $this->maxBolas = $maxBolas;
        $this->mensaje = $mensaje;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('juego.' . $this->juegoId);
    }

    public function broadcastAs(): string
    {
        return 'configuracion.actualizada';
    }
}
