<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class JugadorSalio implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $nombreJugador;
    public int $totalJugadores;
    public int $totalCartones;

    public function __construct(int $juegoId, string $nombreJugador, int $totalJugadores, int $totalCartones)
    {
        $this->juegoId = $juegoId;
        $this->nombreJugador = $nombreJugador;
        $this->totalJugadores = $totalJugadores;
        $this->totalCartones = $totalCartones;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('juego.' . $this->juegoId);
    }

    public function broadcastAs(): string
    {
        return 'jugador.salio';
    }
}
