<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MensajeAdmin implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $mensaje;
    public string $tipo;
    public ?string $gif;

    public function __construct(int $juegoId, string $mensaje, string $tipo = 'info', ?string $gif = null)
    {
        $this->juegoId = $juegoId;
        $this->mensaje = $mensaje;
        $this->tipo = $tipo;
        $this->gif = $gif;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('juego.' . $this->juegoId);
    }

    public function broadcastAs(): string
    {
        return 'mensaje.admin';
    }
}
