<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SorteoAutoIniciado implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $controladorId;
    public string $controladorNombre;
    public string $estado;

    public function __construct(int $juegoId, string $controladorId, string $controladorNombre, string $estado)
    {
        $this->juegoId = $juegoId;
        $this->controladorId = $controladorId;
        $this->controladorNombre = $controladorNombre;
        $this->estado = $estado;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('juego.' . $this->juegoId);
    }

    public function broadcastAs(): string
    {
        return 'sorteo.auto.iniciado';
    }
}
