<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BolaSorteada extends Model
{
    protected $table = 'bolas_sorteadas';

    protected $fillable = [
        'juego_id',
        'numero',
        'letra',
        'orden',
    ];

    public function juego(): BelongsTo
    {
        return $this->belongsTo(Juego::class);
    }

    public function getColorClass(): string
    {
        return match ($this->letra) {
            'B' => 'from-blue-500 to-blue-700',
            'I' => 'from-red-500 to-red-700',
            'N' => 'from-gray-100 to-gray-300 text-gray-800',
            'G' => 'from-green-500 to-green-700',
            'O' => 'from-yellow-400 to-yellow-600',
            default => 'from-gray-500 to-gray-700',
        };
    }

    public function getDisplay(): string
    {
        return $this->letra . '-' . $this->numero;
    }
}
