<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('juegos', function (Blueprint $table) {
            $table->id();
            $table->string('codigo')->unique();
            $table->enum('estado', ['esperando', 'en_curso', 'finalizado'])->default('esperando');
            $table->decimal('precio_carton', 10, 2)->default(1000);
            $table->decimal('acumulado', 15, 2)->default(0);
            $table->decimal('premio_linea', 15, 2)->default(0);
            $table->decimal('premio_bingo', 15, 2)->default(0);
            $table->integer('bolas_sorteadas')->default(0);
            $table->foreignId('ganador_linea_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('ganador_bingo_id')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('inicio_at')->nullable();
            $table->timestamp('fin_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('juegos');
    }
};
