<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cartones', function (Blueprint $table) {
            $table->id();
            $table->foreignId('juego_id')->constrained('juegos')->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('session_id')->nullable();
            $table->json('numeros');
            $table->json('marcados')->nullable();
            $table->boolean('tiene_linea')->default(false);
            $table->boolean('tiene_bingo')->default(false);
            $table->decimal('apuesta', 10, 2)->default(1);
            $table->integer('posicion')->default(1);
            $table->timestamps();
            
            $table->index(['juego_id', 'user_id']);
            $table->index(['juego_id', 'session_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cartones');
    }
};
