<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bolas_sorteadas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('juego_id')->constrained('juegos')->cascadeOnDelete();
            $table->integer('numero');
            $table->char('letra', 1);
            $table->integer('orden');
            $table->timestamps();
            
            $table->unique(['juego_id', 'numero']);
            $table->index(['juego_id', 'orden']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bolas_sorteadas');
    }
};
