@extends('layouts.app')

@section('title', 'Acceso Moderador')

@section('content')
<div class="min-h-[calc(100vh-140px)] flex items-center justify-center p-4">
    <div class="glass-effect rounded-3xl p-8 max-w-md w-full">
        <div class="text-center mb-8">
            <div class="w-20 h-20 mx-auto rounded-full bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center shadow-2xl shadow-purple-500/30 mb-4">
                <span class="text-4xl">🎰</span>
            </div>
            <h1 class="text-2xl font-black text-white mb-2">Panel de Moderador</h1>
            <p class="text-gray-400 text-sm">Ingresa la contraseña de administrador</p>
        </div>

        @if(session('error'))
            <div class="mb-6 p-3 rounded-lg bg-red-500/20 border border-red-500/30 text-red-400 text-sm text-center">
                {{ session('error') }}
            </div>
        @endif

        <form action="{{ route('admin.login.submit') }}" method="POST" class="space-y-6">
            @csrf
            
            <div>
                <label for="password" class="block text-sm font-semibold text-gray-400 mb-2 uppercase tracking-wider">Contraseña</label>
                <input type="password" 
                       id="password" 
                       name="password" 
                       required
                       autofocus
                       class="w-full px-4 py-3 rounded-xl bg-gray-800 border border-gray-600 text-white font-bold text-lg focus:border-purple-500 focus:outline-none focus:ring-2 focus:ring-purple-500/20 text-center tracking-widest"
                       placeholder="••••••••">
            </div>

            <button type="submit" 
                    class="w-full py-4 rounded-xl font-bold text-lg bg-gradient-to-r from-purple-500 to-indigo-600 text-white hover:from-purple-400 hover:to-indigo-500 transition-all shadow-lg shadow-purple-500/30">
                🔐 Acceder al Panel
            </button>
        </form>

        <div class="mt-6 text-center">
            <a href="{{ route('bingo.index') }}" class="text-sm text-gray-500 hover:text-gray-300 transition-colors">
                ← Volver al juego
            </a>
        </div>
    </div>
</div>
@endsection
