<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - ¡Gana Premios Increíbles!</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Bangers&family=Poppins:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        .font-bangers { font-family: 'Bangers', cursive; }
        
        @keyframes float { 
            0%, 100% { transform: translateY(0px) rotate(0deg); } 
            50% { transform: translateY(-20px) rotate(5deg); } 
        }
        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 20px rgba(234, 179, 8, 0.5); }
            50% { box-shadow: 0 0 60px rgba(234, 179, 8, 0.8), 0 0 100px rgba(234, 179, 8, 0.4); }
        }
        @keyframes spin-slow { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
        @keyframes bounce-ball {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-15px); }
        }
        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }
        @keyframes counter-up {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .animate-float { animation: float 3s ease-in-out infinite; }
        .animate-float-delay { animation: float 3s ease-in-out infinite 0.5s; }
        .animate-float-delay-2 { animation: float 3s ease-in-out infinite 1s; }
        .animate-pulse-glow { animation: pulse-glow 2s ease-in-out infinite; }
        .animate-spin-slow { animation: spin-slow 20s linear infinite; }
        .animate-bounce-ball { animation: bounce-ball 1s ease-in-out infinite; }
        .animate-bounce-ball-2 { animation: bounce-ball 1s ease-in-out infinite 0.2s; }
        .animate-bounce-ball-3 { animation: bounce-ball 1s ease-in-out infinite 0.4s; }
        
        .shimmer-text {
            background: linear-gradient(90deg, #ffd700, #fff, #ffd700);
            background-size: 200% auto;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: shimmer 3s linear infinite;
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .bingo-ball {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.5rem;
            box-shadow: inset -5px -5px 15px rgba(0,0,0,0.3), inset 5px 5px 15px rgba(255,255,255,0.3);
        }
        
        .hero-gradient {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
        }
        
        .feature-card:hover {
            transform: translateY(-10px) scale(1.02);
        }
    </style>
</head>
<body class="hero-gradient min-h-screen text-white overflow-x-hidden">
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        <div class="absolute top-20 left-10 w-32 h-32 bg-yellow-500/10 rounded-full blur-3xl"></div>
        <div class="absolute top-40 right-20 w-40 h-40 bg-purple-500/10 rounded-full blur-3xl"></div>
        <div class="absolute bottom-40 left-1/4 w-48 h-48 bg-blue-500/10 rounded-full blur-3xl"></div>
        <div class="absolute bottom-20 right-1/3 w-36 h-36 bg-green-500/10 rounded-full blur-3xl"></div>
    </div>

    <nav class="relative z-10 px-6 py-4">
        <div class="max-w-7xl mx-auto flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="text-4xl">🎱</div>
                <span class="font-bangers text-3xl tracking-wider text-yellow-400">BINGO ELECTRÓNICO</span>
            </div>
            <div class="flex gap-4">
                <a href="{{ route('login') }}" 
                   class="px-6 py-2 rounded-full border-2 border-white/30 hover:border-yellow-400 hover:text-yellow-400 transition-all font-semibold">
                    Iniciar Sesión
                </a>
                <a href="{{ route('register') }}" 
                   class="px-6 py-2 rounded-full bg-gradient-to-r from-yellow-500 to-orange-500 hover:from-yellow-400 hover:to-orange-400 transition-all font-semibold shadow-lg shadow-yellow-500/30">
                    Registrarse
                </a>
            </div>
        </div>
    </nav>

    <main class="relative z-10">
        <section class="py-16 px-6">
            <div class="max-w-7xl mx-auto grid lg:grid-cols-2 gap-12 items-center">
                <div class="text-center lg:text-left">
                    <h1 class="font-bangers text-5xl md:text-7xl lg:text-8xl tracking-wider mb-6">
                        <span class="shimmer-text">¡GANA</span>
                        <br>
                        <span class="text-white">EN GRANDE!</span>
                    </h1>
                    <p class="text-xl md:text-2xl text-gray-300 mb-8 leading-relaxed">
                        El bingo más emocionante de Internet. 
                        <span class="text-yellow-400 font-semibold">Premios en tiempo real</span>, 
                        juega contra otros jugadores y llévate el 
                        <span class="text-green-400 font-semibold">pozo acumulado</span>.
                    </p>
                    
                    <div class="glass-effect rounded-3xl p-8 mb-8 animate-pulse-glow">
                        <p class="text-sm uppercase tracking-widest text-gray-400 mb-2">💰 Pozo Acumulado</p>
                        <p class="font-bangers text-5xl md:text-6xl text-yellow-400">
                            ${{ number_format($acumulado, 0, ',', '.') }}
                        </p>
                        <p class="text-sm text-gray-400 mt-2">
                            <span class="inline-block w-2 h-2 bg-green-500 rounded-full animate-pulse mr-1"></span>
                            {{ $totalJugadores }} jugadores en línea
                        </p>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                        <a href="{{ route('register') }}" 
                           class="px-8 py-4 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-400 hover:to-emerald-500 transition-all font-bold text-xl shadow-xl shadow-green-500/30 flex items-center justify-center gap-2">
                            🎮 JUGAR AHORA
                        </a>
                        <a href="#como-jugar" 
                           class="px-8 py-4 rounded-2xl glass-effect hover:bg-white/20 transition-all font-semibold text-xl flex items-center justify-center gap-2">
                            📖 Cómo Jugar
                        </a>
                    </div>
                </div>

                <div class="relative flex justify-center items-center">
                    <div class="absolute w-72 h-72 bg-yellow-500/20 rounded-full blur-3xl animate-pulse"></div>
                    
                    <div class="relative">
                        <div class="w-64 h-64 md:w-80 md:h-80 rounded-full bg-gradient-to-br from-gray-700 to-gray-900 flex items-center justify-center shadow-2xl animate-spin-slow" style="animation-duration: 30s;">
                            <div class="w-56 h-56 md:w-72 md:h-72 rounded-full bg-gradient-to-br from-gray-600 to-gray-800 flex items-center justify-center">
                                <div class="w-48 h-48 md:w-64 md:h-64 rounded-full bg-gradient-to-br from-gray-500 to-gray-700 flex items-center justify-center">
                                    <span class="text-6xl md:text-8xl animate-bounce">🎱</span>
                                </div>
                            </div>
                        </div>

                        <div class="absolute -top-4 -left-4 bingo-ball bg-gradient-to-br from-red-400 to-red-600 text-white animate-bounce-ball">B7</div>
                        <div class="absolute -top-4 -right-4 bingo-ball bg-gradient-to-br from-blue-400 to-blue-600 text-white animate-bounce-ball-2">I22</div>
                        <div class="absolute -bottom-4 -left-4 bingo-ball bg-gradient-to-br from-green-400 to-green-600 text-white animate-bounce-ball-3">N45</div>
                        <div class="absolute -bottom-4 -right-4 bingo-ball bg-gradient-to-br from-yellow-400 to-yellow-600 text-gray-800 animate-bounce-ball">G58</div>
                        <div class="absolute top-1/2 -right-12 bingo-ball bg-gradient-to-br from-purple-400 to-purple-600 text-white animate-bounce-ball-2">O75</div>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-16 px-6 bg-black/30">
            <div class="max-w-7xl mx-auto">
                <h2 class="font-bangers text-4xl md:text-5xl text-center mb-12 text-yellow-400">¿POR QUÉ ELEGIRNOS?</h2>
                
                <div class="grid md:grid-cols-3 gap-8">
                    <div class="glass-effect rounded-3xl p-8 text-center feature-card transition-all duration-300">
                        <div class="text-6xl mb-4">⚡</div>
                        <h3 class="text-2xl font-bold mb-3 text-yellow-400">Tiempo Real</h3>
                        <p class="text-gray-300">Juega con otros participantes en vivo. Las bolas se sortean en tiempo real para todos los jugadores.</p>
                    </div>
                    
                    <div class="glass-effect rounded-3xl p-8 text-center feature-card transition-all duration-300">
                        <div class="text-6xl mb-4">💰</div>
                        <h3 class="text-2xl font-bold mb-3 text-green-400">Premios Reales</h3>
                        <p class="text-gray-300">Gana premios por línea y por bingo completo. El pozo acumulado crece con cada jugador.</p>
                    </div>
                    
                    <div class="glass-effect rounded-3xl p-8 text-center feature-card transition-all duration-300">
                        <div class="text-6xl mb-4">🔒</div>
                        <h3 class="text-2xl font-bold mb-3 text-blue-400">100% Seguro</h3>
                        <p class="text-gray-300">Sistema certificado de sorteo aleatorio. Tus datos y dinero están protegidos.</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="como-jugar" class="py-16 px-6">
            <div class="max-w-7xl mx-auto">
                <h2 class="font-bangers text-4xl md:text-5xl text-center mb-12 text-yellow-400">¿CÓMO JUGAR?</h2>
                
                <div class="grid md:grid-cols-4 gap-6">
                    <div class="text-center">
                        <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-yellow-500 to-orange-500 flex items-center justify-center text-3xl font-bold shadow-lg">1</div>
                        <h3 class="text-xl font-bold mb-2">Regístrate</h3>
                        <p class="text-gray-400">Crea tu cuenta gratis y recibe $100,000 de saldo inicial para jugar.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-blue-500 to-cyan-500 flex items-center justify-center text-3xl font-bold shadow-lg">2</div>
                        <h3 class="text-xl font-bold mb-2">Compra Cartones</h3>
                        <p class="text-gray-400">Elige entre 1 y 4 cartones. Cada cartón cuesta $1,000.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-green-500 to-emerald-500 flex items-center justify-center text-3xl font-bold shadow-lg">3</div>
                        <h3 class="text-xl font-bold mb-2">Ajusta tu Apuesta</h3>
                        <p class="text-gray-400">Multiplica tu apuesta hasta x50 para ganar premios más grandes.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-purple-500 to-pink-500 flex items-center justify-center text-3xl font-bold shadow-lg">4</div>
                        <h3 class="text-xl font-bold mb-2">¡Gana!</h3>
                        <p class="text-gray-400">Completa una línea o el cartón completo y llévate el premio.</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-16 px-6 bg-gradient-to-r from-yellow-500/20 to-orange-500/20">
            <div class="max-w-4xl mx-auto text-center">
                <h2 class="font-bangers text-4xl md:text-5xl mb-6 text-white">🎁 BONO DE BIENVENIDA</h2>
                <div class="glass-effect rounded-3xl p-8">
                    <p class="text-6xl font-bangers text-yellow-400 mb-4">$100,000</p>
                    <p class="text-xl text-gray-300 mb-6">¡Regístrate ahora y recibe saldo gratis para empezar a jugar!</p>
                    <a href="{{ route('register') }}" 
                       class="inline-block px-10 py-4 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-400 hover:to-emerald-500 transition-all font-bold text-xl shadow-xl shadow-green-500/30">
                        🚀 RECLAMAR BONO
                    </a>
                </div>
            </div>
        </section>

        <section class="py-16 px-6">
            <div class="max-w-7xl mx-auto">
                <h2 class="font-bangers text-4xl md:text-5xl text-center mb-12 text-yellow-400">PREMIOS</h2>
                
                <div class="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
                    <div class="glass-effect rounded-3xl p-8 text-center border-2 border-blue-500/50">
                        <div class="text-5xl mb-4">📏</div>
                        <h3 class="text-3xl font-bold mb-2 text-blue-400">Premio Línea</h3>
                        <p class="text-gray-400 mb-4">Completa una línea horizontal</p>
                        <p class="text-4xl font-bangers text-white">30%</p>
                        <p class="text-sm text-gray-500">del pozo acumulado</p>
                    </div>
                    
                    <div class="glass-effect rounded-3xl p-8 text-center border-2 border-yellow-500/50">
                        <div class="text-5xl mb-4">🏆</div>
                        <h3 class="text-3xl font-bold mb-2 text-yellow-400">Premio Bingo</h3>
                        <p class="text-gray-400 mb-4">Completa todo el cartón</p>
                        <p class="text-4xl font-bangers text-white">70%</p>
                        <p class="text-sm text-gray-500">del pozo acumulado</p>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="relative z-10 py-8 px-6 border-t border-white/10">
        <div class="max-w-7xl mx-auto text-center text-gray-500">
            <p class="mb-2">{{ config('app.name') }} © {{ date('Y') }} - Todos los derechos reservados</p>
            <p class="text-sm">🎰 Juega responsablemente. Solo para mayores de 18 años.</p>
        </div>
    </footer>
</body>
</html>
