<?php

use App\Http\Controllers\BingoController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

// Rutas públicas (landing y auth)
Route::get('/', [AuthController::class, 'landing'])->name('landing');
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Google OAuth
Route::get('/auth/google', [AuthController::class, 'redirectToGoogle'])->name('auth.google');
Route::get('/auth/google/callback', [AuthController::class, 'handleGoogleCallback']);

// Rutas protegidas del juego
Route::middleware('auth')->group(function () {
    Route::get('/bingo', [BingoController::class, 'index'])->name('bingo.index');
    Route::get('/jugar/{juego}', [BingoController::class, 'jugar'])->name('bingo.jugar');
    Route::post('/comprar/{juego}', [BingoController::class, 'comprarCartones'])->name('bingo.comprar');
    Route::post('/sortear/{juego}', [BingoController::class, 'sortearBola'])->name('bingo.sortear');
    Route::get('/estado/{juego}', [BingoController::class, 'obtenerEstado'])->name('bingo.estado');
    Route::post('/reiniciar', [BingoController::class, 'reiniciar'])->name('bingo.reiniciar');
    Route::post('/abandonar/{juego}', [BingoController::class, 'abandonarJuego'])->name('bingo.abandonar');
    Route::post('/ajustar-apuesta/{juego}', [BingoController::class, 'ajustarApuesta'])->name('bingo.ajustar');
    Route::post('/multiplicar/{juego}', [BingoController::class, 'multiplicarApuesta'])->name('bingo.multiplicar');
    Route::post('/reiniciar-balance', [BingoController::class, 'reiniciarBalance'])->name('bingo.reiniciarBalance');
    
    // Rutas de recarga
    Route::get('/recargar', [BingoController::class, 'recargar'])->name('bingo.recargar');
    Route::post('/recargar/procesar', [BingoController::class, 'procesarRecarga'])->name('bingo.procesarRecarga');
    
    // Rutas de sorteo automático
    Route::post('/sorteo-auto/iniciar/{juego}', [BingoController::class, 'iniciarSorteoAuto'])->name('bingo.sorteoAuto.iniciar');
    Route::post('/sorteo-auto/detener/{juego}', [BingoController::class, 'detenerSorteoAuto'])->name('bingo.sorteoAuto.detener');
    Route::get('/sorteo-auto/estado/{juego}', [BingoController::class, 'estadoSorteoAuto'])->name('bingo.sorteoAuto.estado');
});

// Ruta de prueba de Pusher
Route::get('/test-pusher/{juego}', function(\App\Models\Juego $juego) {
    broadcast(new \App\Events\MensajeAdmin($juego->id, '🧪 Prueba de Pusher - ' . now()->format('H:i:s'), 'info'));
    return response()->json(['success' => true, 'message' => 'Evento enviado a canal juego.' . $juego->id]);
});

// Rutas del Moderador/Admin
Route::get('/admin', [AdminController::class, 'loginForm'])->name('admin.login');
Route::post('/admin/login', [AdminController::class, 'login'])->name('admin.login.submit');
Route::get('/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');
Route::get('/admin/panel', [AdminController::class, 'panel'])->name('admin.panel');
Route::post('/admin/iniciar-sorteo/{juego}', [AdminController::class, 'iniciarSorteo'])->name('admin.iniciarSorteo');
Route::post('/admin/detener-sorteo/{juego}', [AdminController::class, 'detenerSorteo'])->name('admin.detenerSorteo');
Route::post('/admin/sortear/{juego}', [AdminController::class, 'sortearBola'])->name('admin.sortear');
Route::post('/admin/mensaje/{juego}', [AdminController::class, 'enviarMensaje'])->name('admin.mensaje');
Route::post('/admin/reiniciar/{juego}', [AdminController::class, 'reiniciarJuego'])->name('admin.reiniciar');
Route::post('/admin/max-bolas/{juego}', [AdminController::class, 'cambiarMaxBolas'])->name('admin.maxBolas');