<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <title><?php echo e(config('app.name', 'Bingo Electrónico')); ?> - <?php echo $__env->yieldContent('title', 'Juega y Gana'); ?></title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;500;600;700;800;900&family=Press+Start+2P&display=swap" rel="stylesheet">
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <script>
        window.PUSHER_CONFIG = {
            key: '<?php echo e(config("broadcasting.connections.pusher.key")); ?>',
            cluster: '<?php echo e(config("broadcasting.connections.pusher.options.cluster")); ?>'
        };
    </script>
    
    <style>
        [x-cloak] { display: none !important; }
        body {
            font-family: 'Orbitron', sans-serif;
        }
        .font-pixel {
            font-family: 'Press Start 2P', cursive;
        }
    </style>
</head>
<body class="min-h-screen casino-gradient text-white overflow-x-hidden">
    <div id="app" class="min-h-screen flex flex-col">
        <header class="relative z-50">
            <nav class="glass-effect border-b border-yellow-500/30">
                <div class="max-w-7xl mx-auto px-4 py-3">
                    <div class="flex items-center justify-between">
                        <a href="<?php echo e(route('bingo.index')); ?>" class="flex items-center gap-3 group">
                            <div class="relative w-14 h-14 group-hover:scale-110 transition-transform">
                                <!-- Bolas de fondo -->
                                <div class="absolute -top-1 -left-1 w-6 h-6 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 shadow-lg shadow-blue-500/30 flex items-center justify-center">
                                    <div class="w-3 h-3 rounded-full bg-white"></div>
                                </div>
                                <div class="absolute -top-1 right-0 w-5 h-5 rounded-full bg-gradient-to-br from-red-400 to-red-600 shadow-lg shadow-red-500/30 flex items-center justify-center">
                                    <div class="w-2.5 h-2.5 rounded-full bg-white"></div>
                                </div>
                                <div class="absolute bottom-0 -left-1 w-5 h-5 rounded-full bg-gradient-to-br from-green-400 to-green-600 shadow-lg shadow-green-500/30 flex items-center justify-center">
                                    <div class="w-2.5 h-2.5 rounded-full bg-white"></div>
                                </div>
                                <!-- Bola principal -->
                                <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-10 h-10 rounded-full bg-gradient-to-br from-yellow-300 via-yellow-400 to-orange-500 shadow-xl shadow-yellow-500/50 flex items-center justify-center border-2 border-yellow-200/50">
                                    <div class="w-6 h-6 rounded-full bg-white flex items-center justify-center shadow-inner">
                                        <span class="text-sm font-black text-yellow-600">B</span>
                                    </div>
                                </div>
                                <!-- Bola inferior derecha -->
                                <div class="absolute -bottom-1 right-0 w-5 h-5 rounded-full bg-gradient-to-br from-purple-400 to-purple-600 shadow-lg shadow-purple-500/30 flex items-center justify-center">
                                    <div class="w-2.5 h-2.5 rounded-full bg-white"></div>
                                </div>
                            </div>
                            <div>
                                <h1 class="text-xl font-black tracking-wider">
                                    <span class="text-blue-400">B</span><span class="text-red-400">I</span><span class="text-white">N</span><span class="text-green-400">G</span><span class="text-yellow-400">O</span>
                                </h1>
                                <p class="text-[9px] text-yellow-400/80 tracking-[0.2em] uppercase font-semibold">Electrónico</p>
                            </div>
                        </a>
                        
                    </div>
                </div>
            </nav>
        </header>

        <main class="flex-1 relative">
            <?php if(session('success')): ?>
                <div x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 4000)"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-x-8"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 translate-x-8"
                     class="fixed top-20 right-4 z-50">
                    <div class="glass-effect bg-green-500/20 border border-green-500/50 rounded-lg px-4 py-3 flex items-center gap-3 shadow-lg shadow-green-500/20">
                        <svg class="w-5 h-5 text-green-400 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span class="text-green-300 text-sm"><?php echo e(session('success')); ?></span>
                        <button @click="show = false" class="ml-2 text-green-400 hover:text-green-300 transition-colors">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div x-data="{ show: true }" 
                     x-show="show" 
                     x-init="setTimeout(() => show = false, 5000)"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-x-8"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 translate-x-8"
                     class="fixed top-20 right-4 z-50">
                    <div class="glass-effect bg-red-500/20 border border-red-500/50 rounded-lg px-4 py-3 flex items-center gap-3 shadow-lg shadow-red-500/20">
                        <svg class="w-5 h-5 text-red-400 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span class="text-red-300 text-sm"><?php echo e(session('error')); ?></span>
                        <button @click="show = false" class="ml-2 text-red-400 hover:text-red-300 transition-colors">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <footer class="glass-effect border-t border-yellow-500/20 py-4">
            <div class="max-w-7xl mx-auto px-4 text-center">
                <p class="text-xs text-gray-400">© <?php echo e(date('Y')); ?> Bingo Electrónico - Juega responsablemente</p>
            </div>
        </footer>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /Users/arzabala/Documents/proyecto/bingo-electronico/resources/views/layouts/app.blade.php ENDPATH**/ ?>