<?php $__env->startSection('title', 'Panel Moderador'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-[calc(100vh-140px)] p-3 md:p-4" x-data="adminPanel()" x-init="init()">
    <div class="max-w-7xl mx-auto space-y-4">

        <!-- Header -->
        <div class="glass-effect rounded-xl p-4 border border-purple-500/30 bg-gradient-to-r from-purple-500/10 to-indigo-500/10">
            <div class="flex items-center justify-between flex-wrap gap-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center shadow-lg shadow-purple-500/30">
                        <span class="text-2xl">🎰</span>
                    </div>
                    <div>
                        <h1 class="text-xl font-black text-white">Panel de Moderador</h1>
                        <p class="text-xs text-purple-400">Control total del sorteo</p>
                    </div>
                </div>
                <div class="flex items-center gap-3">
                    <span class="px-3 py-1.5 rounded-full text-xs font-bold bg-green-500/20 text-green-400 border border-green-500/30 flex items-center gap-2">
                        <span class="w-2 h-2 rounded-full bg-green-500 animate-pulse"></span>
                        EN LÍNEA
                    </span>
                    <a href="<?php echo e(route('admin.logout')); ?>" class="px-4 py-2 rounded-lg text-sm font-semibold bg-gray-700 text-gray-300 hover:bg-red-600 hover:text-white transition-colors">
                        🚪 Salir
                    </a>
                </div>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
            <div class="glass-effect rounded-xl p-4 text-center border border-cyan-500/30">
                <p class="text-cyan-400 text-[10px] uppercase tracking-wider mb-1">👥 Jugadores</p>
                <p class="text-3xl font-black text-white" x-text="totalJugadores"><?php echo e($totalJugadores); ?></p>
            </div>
            <div class="glass-effect rounded-xl p-4 text-center border border-yellow-500/30">
                <p class="text-yellow-400 text-[10px] uppercase tracking-wider mb-1">🎫 Cartones</p>
                <p class="text-3xl font-black text-white" x-text="totalCartones"><?php echo e($totalCartones); ?></p>
            </div>
            <div class="glass-effect rounded-xl p-4 text-center border border-green-500/30">
                <p class="text-green-400 text-[10px] uppercase tracking-wider mb-1">💰 Acumulado</p>
                <p class="text-2xl font-black text-green-400">$<span x-text="Number(acumulado).toLocaleString()"><?php echo e(number_format($juego->acumulado, 0)); ?></span></p>
            </div>
            <div class="glass-effect rounded-xl p-4 text-center border border-purple-500/30">
                <p class="text-purple-400 text-[10px] uppercase tracking-wider mb-1">🎱 Bolas</p>
                <p class="text-3xl font-black text-white"><span x-text="bolasSorteadas"><?php echo e($bolasSorteadas); ?></span><span class="text-lg text-gray-500">/<span x-text="maxBolas"><?php echo e($juego->max_bolas ?? 60); ?></span></span></p>
            </div>
        </div>

        <!-- Layout Principal -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
            <!-- Columna Izquierda: Control del Sorteo -->
            <div class="lg:col-span-2 space-y-4">
                <!-- Control del Sorteo -->
                <div class="glass-effect rounded-xl p-5 border border-yellow-500/30 bg-gradient-to-br from-yellow-500/5 to-orange-500/5">
                    <h2 class="text-lg font-bold text-yellow-400 mb-4 flex items-center gap-2">
                        <span>🎲</span> Control del Sorteo
                    </h2>
                    
                    <div class="flex flex-col md:flex-row items-center gap-5">
                        <!-- Bola -->
                        <div class="relative">
                            <div class="w-36 h-36 rounded-full bg-gradient-to-br from-gray-800 to-gray-900 border-4 border-yellow-500/50 flex items-center justify-center shadow-xl"
                                 :class="{ 'animate-shake': isDrawing }">
                                <div x-show="!ultimaBola && !isDrawing" class="text-5xl font-black text-yellow-500/40">?</div>
                                <div x-show="isDrawing" class="w-16 h-16 rounded-full bg-gradient-to-br from-yellow-300 to-yellow-500 animate-spin shadow-lg"></div>
                                <div x-show="ultimaBola && !isDrawing" class="text-center">
                                    <p class="text-sm font-bold text-gray-400" x-text="ultimaBola?.letra"></p>
                                    <p class="text-4xl font-black text-white" x-text="ultimaBola?.numero"></p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Botones -->
                        <div class="flex-1 w-full space-y-3">
                            <button @click="sortearBola()" 
                                    :disabled="isDrawing || estado === 'finalizado'"
                                    class="w-full py-3 rounded-xl font-bold text-white bg-gradient-to-r from-green-500 to-emerald-600 hover:from-green-400 hover:to-emerald-500 transition-all disabled:opacity-50 disabled:cursor-not-allowed shadow-lg shadow-green-500/20">
                                <span x-show="!isDrawing">▶ Sortear Bola</span>
                                <span x-show="isDrawing">⏳ Sorteando...</span>
                            </button>
                            
                            <button @click="toggleSorteoAuto()" 
                                    :disabled="estado === 'finalizado'"
                                    :class="sorteoActivo ? 'from-red-500 to-rose-600 shadow-red-500/20' : 'from-blue-500 to-indigo-600 shadow-blue-500/20'"
                                    class="w-full py-3 rounded-xl font-bold text-white bg-gradient-to-r transition-all disabled:opacity-50 shadow-lg">
                                <span x-text="sorteoActivo ? '⏹ Detener Auto' : '🔄 Iniciar Auto (4.5s)'"></span>
                            </button>
                            
                            <button @click="showReiniciarModal = true" 
                                    class="w-full py-2 rounded-xl font-semibold text-gray-300 bg-gray-700/80 hover:bg-gray-600 transition-all text-sm">
                                🔄 Reiniciar Juego
                            </button>
                        </div>
                    </div>

                    <!-- Configuración de bolas -->
                    <div class="mt-5 pt-4 border-t border-yellow-500/20">
                        <div class="flex items-center justify-between mb-4">
                            <p class="text-sm text-gray-400 flex items-center gap-2">
                                ⚙️ <span>Bolas del sorteo:</span>
                            </p>
                            <div class="flex items-center gap-2">
                                <template x-for="opcion in [50, 60, 70]" :key="opcion">
                                    <button @click="cambiarMaxBolas(opcion)"
                                            :disabled="estado === 'en_curso'"
                                            :class="maxBolas == opcion 
                                                ? 'bg-gradient-to-r from-yellow-500 to-orange-500 text-gray-900 font-black ring-2 ring-yellow-300' 
                                                : 'bg-gray-700 text-gray-300 hover:bg-gray-600'"
                                            class="px-4 py-2 rounded-lg text-sm font-bold transition-all disabled:opacity-50 disabled:cursor-not-allowed shadow-md">
                                        <span x-text="opcion"></span>
                                    </button>
                                </template>
                            </div>
                        </div>
                    </div>

                    <!-- Historial de bolas -->
                    <div class="mt-4 pt-4 border-t border-yellow-500/20">
                        <div class="flex items-center justify-between mb-3">
                            <p class="text-sm text-gray-400">Últimas bolas:</p>
                            <div class="h-2 flex-1 mx-4 bg-gray-700 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-yellow-500 to-orange-500 transition-all"
                                     :style="'width: ' + (bolasSorteadas / maxBolas * 100) + '%'"></div>
                            </div>
                            <span class="text-xs px-2 py-1 rounded-full bg-rose-500/20 text-rose-400 font-bold" x-text="(maxBolas - bolasSorteadas) + ' restantes'"></span>
                        </div>
                        <div class="flex flex-wrap gap-2">
                            <template x-for="bola in historial" :key="bola.orden">
                                <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold shadow-md"
                                     :class="{
                                         'bg-gradient-to-br from-blue-400 to-blue-600 text-white': bola.letra === 'B',
                                         'bg-gradient-to-br from-red-400 to-red-600 text-white': bola.letra === 'I',
                                         'bg-gradient-to-br from-gray-200 to-gray-400 text-gray-800': bola.letra === 'N',
                                         'bg-gradient-to-br from-green-400 to-green-600 text-white': bola.letra === 'G',
                                         'bg-gradient-to-br from-yellow-300 to-yellow-500 text-gray-800': bola.letra === 'O'
                                     }" x-text="bola.numero"></div>
                            </template>
                            <template x-if="historial.length === 0">
                                <p class="text-gray-500 text-sm">Sin bolas sorteadas</p>
                            </template>
                        </div>
                    </div>
                </div>

                <!-- Mensajes -->
                <div class="glass-effect rounded-xl p-5 border border-indigo-500/30">
                    <h2 class="text-lg font-bold text-indigo-400 mb-4 flex items-center gap-2">
                        <span>📢</span> Enviar Mensaje
                    </h2>
                    
                    <div class="space-y-3">
                        <div class="flex gap-2">
                            <select x-model="tipoMensaje" class="px-3 py-2 rounded-lg bg-gray-800 border border-gray-600 text-white text-sm focus:border-indigo-500 focus:outline-none">
                                <option value="info">ℹ️ Info</option>
                                <option value="alerta">⚠️ Alerta</option>
                                <option value="exito">✅ Éxito</option>
                                <option value="promo">🎁 Promo</option>
                            </select>
                            <input type="text" 
                                   x-model="mensaje"
                                   x-ref="mensajeInput"
                                   placeholder="Escribe un mensaje..."
                                   class="flex-1 px-4 py-2 rounded-lg bg-gray-800 border border-gray-600 text-white text-sm focus:border-indigo-500 focus:outline-none"
                                   @keyup.enter="enviarMensaje()">
                            <button @click="enviarMensaje()" 
                                    :disabled="!mensaje.trim()"
                                    class="px-5 py-2 rounded-lg font-semibold bg-gradient-to-r from-indigo-500 to-purple-500 text-white hover:from-indigo-400 hover:to-purple-400 transition-all disabled:opacity-50">
                                📤
                            </button>
                        </div>

                        <!-- Selector de GIF -->
                        <div class="space-y-2">
                            <div class="flex items-center gap-2">
                                <span class="text-xs text-gray-400">🎬 GIF:</span>
                                <div class="flex-1 flex gap-1 overflow-x-auto pb-1">
                                    <button @click="gifSeleccionado = null; gifCustom = ''" 
                                            :class="!gifSeleccionado ? 'ring-2 ring-indigo-500 bg-gray-600' : 'bg-gray-700'"
                                            class="px-3 py-1 rounded text-xs text-gray-300 hover:bg-gray-600 transition-all whitespace-nowrap">
                                        Sin GIF
                                    </button>
                                    <template x-for="(gif, key) in gifsDisponibles" :key="key">
                                        <button @click="gifSeleccionado = gif.url; gifCustom = ''" 
                                                :class="gifSeleccionado === gif.url ? 'ring-2 ring-indigo-500 bg-gray-600' : 'bg-gray-700'"
                                                class="px-2 py-1 rounded text-xs hover:bg-gray-600 transition-all whitespace-nowrap flex items-center gap-1">
                                            <span x-text="gif.emoji"></span>
                                            <span class="text-gray-300" x-text="gif.nombre"></span>
                                        </button>
                                    </template>
                                    <button @click="showGifCustomInput = !showGifCustomInput" 
                                            :class="showGifCustomInput ? 'ring-2 ring-pink-500 bg-pink-600' : 'bg-gray-700'"
                                            class="px-3 py-1 rounded text-xs text-gray-300 hover:bg-pink-600 transition-all whitespace-nowrap">
                                        ✨ Custom
                                    </button>
                                </div>
                            </div>

                            <!-- Input para GIF personalizado -->
                            <div x-show="showGifCustomInput" x-transition class="flex gap-2">
                                <input type="url" 
                                       x-model="gifCustom"
                                       @input="if(gifCustom) gifSeleccionado = gifCustom"
                                       placeholder="Pega URL del GIF..."
                                       class="flex-1 px-3 py-2 rounded-lg bg-gray-800 border border-pink-500/50 text-white text-xs focus:border-pink-500 focus:outline-none placeholder-gray-500">
                                <button @click="if(gifCustom) { gifSeleccionado = gifCustom; showGifCustomInput = false; }" 
                                        :disabled="!gifCustom"
                                        class="px-3 py-2 rounded-lg text-xs font-semibold bg-pink-600 text-white hover:bg-pink-500 disabled:opacity-50 disabled:cursor-not-allowed">
                                    ✓ Usar
                                </button>
                            </div>
                        </div>

                        <!-- Preview del GIF seleccionado -->
                        <div x-show="gifSeleccionado" x-transition class="flex items-center gap-3 p-2 rounded-lg bg-gray-800/50 border border-gray-700">
                            <img :src="gifSeleccionado" class="w-16 h-16 rounded object-cover" alt="GIF preview">
                            <div class="flex-1">
                                <p class="text-xs text-gray-400">GIF adjunto</p>
                            </div>
                            <button @click="gifSeleccionado = null; gifCustom = ''" class="text-xs text-red-400 hover:text-red-300 px-2">✕</button>
                        </div>
                        
                        <!-- Mensajes rápidos -->
                        <div class="grid grid-cols-2 md:grid-cols-5 gap-2">
                            <button @click="cargarMensaje('🎉 ¡El sorteo está por comenzar!', 'info', 'celebracion')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-indigo-600 hover:text-white transition-all truncate">
                                🎉 Por comenzar
                            </button>
                            <button @click="cargarMensaje('⏰ ¡Últimos segundos para comprar!', 'alerta', 'reloj')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-yellow-600 hover:text-white transition-all truncate">
                                ⏰ Últimos seg.
                            </button>
                            <button @click="cargarMensaje('🍀 ¡Mucha suerte a todos!', 'exito', 'suerte')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-green-600 hover:text-white transition-all truncate">
                                🍀 Suerte
                            </button>
                            <button @click="cargarMensaje('🔥 ¡El acumulado está muy alto!', 'promo', 'dinero')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-orange-600 hover:text-white transition-all truncate">
                                🔥 Acumulado
                            </button>
                            <button @click="cargarMensaje('⚠️ ¡Quedan pocas bolas!', 'alerta', 'alerta')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-red-600 hover:text-white transition-all truncate">
                                ⚠️ Pocas bolas
                            </button>
                            <button @click="cargarMensaje('🚀 ¡Iniciando en 10 segundos!', 'alerta', 'cohete')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-purple-600 hover:text-white transition-all truncate">
                                🚀 10 segundos
                            </button>
                            <button @click="cargarMensaje('💪 ¡Vamos que se puede!', 'exito', 'motivacion')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-emerald-600 hover:text-white transition-all truncate">
                                💪 Motivar
                            </button>
                            <button @click="cargarMensaje('📢 ¡Bienvenidos al Bingo!', 'info', 'bienvenida')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-cyan-600 hover:text-white transition-all truncate">
                                📢 Bienvenida
                            </button>
                            <button @click="cargarMensaje('🏆 ¡30% línea, 70% bingo!', 'info', null)" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-blue-600 hover:text-white transition-all truncate">
                                🏆 Premios
                            </button>
                            <button @click="cargarMensaje('🎯 ¡Gracias por participar!', 'exito', 'gracias')" class="px-2 py-1.5 rounded-lg text-[11px] font-medium bg-gray-700/80 text-gray-300 hover:bg-teal-600 hover:text-white transition-all truncate">
                                🎯 Despedida
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Columna Derecha -->
            <div class="space-y-4">
                <!-- Jugadores -->
                <div class="glass-effect rounded-xl p-5 border border-cyan-500/30">
                    <h2 class="text-lg font-bold text-cyan-400 mb-4 flex items-center gap-2">
                        <span>👥</span> Jugadores
                        <span class="ml-auto px-2 py-0.5 rounded-full text-xs bg-cyan-500/20 border border-cyan-500/30" x-text="totalJugadores"></span>
                    </h2>
                    
                    <div class="space-y-2 max-h-48 overflow-y-auto">
                        <template x-for="(jugador, index) in jugadores" :key="index">
                            <div class="flex items-center justify-between p-2 rounded-lg bg-gray-800/50 hover:bg-gray-700/50 transition-colors">
                                <div class="flex items-center gap-2">
                                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-cyan-400 to-blue-500 flex items-center justify-center text-xs font-bold text-white" x-text="jugador.nombre.charAt(0).toUpperCase()"></div>
                                    <span class="text-sm font-semibold text-white truncate max-w-[100px]" x-text="jugador.nombre"></span>
                                </div>
                                <div class="text-right">
                                    <p class="text-xs text-yellow-400 font-semibold"><span x-text="jugador.cartones"></span> 🎫</p>
                                </div>
                            </div>
                        </template>
                        <template x-if="jugadores.length === 0">
                            <p class="text-gray-500 text-sm text-center py-6">😴 Sin jugadores</p>
                        </template>
                    </div>
                </div>

                <!-- Premios -->
                <div class="glass-effect rounded-xl p-5 border border-green-500/30">
                    <h2 class="text-lg font-bold text-green-400 mb-3 flex items-center gap-2">
                        <span>💰</span> Premios
                    </h2>
                    
                    <div class="space-y-2">
                        <div class="flex justify-between items-center p-2 rounded-lg bg-gray-800/50">
                            <span class="text-sm text-gray-400">🎯 Línea</span>
                            <span class="font-bold text-green-400">$<span x-text="Number(premioLinea).toLocaleString()"></span></span>
                        </div>
                        <div class="flex justify-between items-center p-2 rounded-lg bg-gray-800/50">
                            <span class="text-sm text-gray-400">🏆 Bingo</span>
                            <span class="font-bold text-purple-400">$<span x-text="Number(premioBingo).toLocaleString()"></span></span>
                        </div>
                        <div class="flex justify-between items-center p-3 rounded-lg bg-gradient-to-r from-yellow-500/10 to-orange-500/10 border border-yellow-500/30">
                            <span class="text-sm text-yellow-400 font-semibold">💎 Total</span>
                            <span class="font-black text-lg text-yellow-400">$<span x-text="Number(acumulado).toLocaleString()"></span></span>
                        </div>
                    </div>
                </div>

                <!-- Estado -->
                <div class="glass-effect rounded-xl p-4 border border-gray-600/30">
                    <div class="flex items-center justify-between">
                        <span class="text-xs text-gray-500">Estado:</span>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 rounded-full"
                                  :class="{
                                      'bg-yellow-500 animate-pulse': estado === 'esperando',
                                      'bg-green-500 animate-pulse': estado === 'en_curso',
                                      'bg-red-500': estado === 'finalizado'
                                  }"></span>
                            <span class="text-sm font-semibold"
                                  :class="{
                                      'text-yellow-400': estado === 'esperando',
                                      'text-green-400': estado === 'en_curso',
                                      'text-red-400': estado === 'finalizado'
                                  }"
                                  x-text="estado === 'esperando' ? 'Esperando' : (estado === 'en_curso' ? 'En Curso' : 'Finalizado')"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Reiniciar -->
    <div x-cloak x-show="showReiniciarModal" 
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/80"
         @click.self="showReiniciarModal = false">
        <div class="glass-effect rounded-2xl p-6 max-w-sm w-full text-center">
            <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-gradient-to-br from-red-500 to-orange-500 flex items-center justify-center">
                <span class="text-3xl">⚠️</span>
            </div>
            <h2 class="text-xl font-black text-white mb-2">¿Reiniciar?</h2>
            <p class="text-gray-400 text-sm mb-4">Se eliminarán todas las bolas y cartones</p>
            <div class="flex gap-3 justify-center">
                <button @click="showReiniciarModal = false" class="px-5 py-2 rounded-xl font-bold bg-gray-600 text-white hover:bg-gray-500">
                    Cancelar
                </button>
                <button @click="confirmarReinicio()" class="px-5 py-2 rounded-xl font-bold bg-gradient-to-r from-red-500 to-orange-500 text-white hover:from-red-400 hover:to-orange-400">
                    🔄 Reiniciar
                </button>
            </div>
        </div>
    </div>

    <!-- Conteo Regresivo -->
    <div x-cloak x-show="showCountdown" 
         class="fixed inset-0 z-[100] flex items-center justify-center bg-black/80 backdrop-blur-sm">
        <div class="text-center">
            <div class="text-6xl mb-4 animate-bounce">🚀</div>
            <p class="text-2xl font-bold text-yellow-400 animate-pulse">Iniciando sorteo...</p>
            <p class="text-gray-400 mt-2">Enviando a jugadores</p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function adminPanel() {
    return {
        juegoId: <?php echo e($juego->id); ?>,
        estado: '<?php echo e($juego->estado); ?>',
        acumulado: <?php echo e((float) $juego->acumulado); ?>,
        premioLinea: <?php echo e((float) $juego->premio_linea); ?>,
        premioBingo: <?php echo e((float) $juego->premio_bingo); ?>,
        bolasSorteadas: <?php echo e($bolasSorteadas); ?>,
        maxBolas: <?php echo e($juego->max_bolas ?? 60); ?>,
        totalJugadores: <?php echo e($totalJugadores); ?>,
        totalCartones: <?php echo e($totalCartones); ?>,
        ultimaBola: null,
        historial: [],
        jugadores: <?php echo json_encode($jugadores, 15, 512) ?>,
        isDrawing: false,
        sorteoActivo: <?php echo e($sorteoActivo ? 'true' : 'false'); ?>,
        autoPlayInterval: null,
        mensaje: '',
        tipoMensaje: 'info',
        gifSeleccionado: null,
        gifCustom: '',
        showGifCustomInput: false,
        gifsDisponibles: {
            celebracion: { nombre: 'Celebración', emoji: '🎉', url: 'https://media.giphy.com/media/artj92V8o75VPL7AeQ/giphy.gif' },
            suerte: { nombre: 'Suerte', emoji: '🍀', url: 'https://media.giphy.com/media/12XDYvMJNcmLgQ/giphy.gif' },
            dinero: { nombre: 'Dinero', emoji: '💰', url: 'https://media.giphy.com/media/67ThRZlYBvibtdF9JH/giphy.gif' },
            bingo: { nombre: 'Bingo', emoji: '🎱', url: 'https://media.giphy.com/media/l0HlBO7eyXzSZkJri/giphy.gif' },
            motivacion: { nombre: 'Motivación', emoji: '💪', url: 'https://media.giphy.com/media/xT5LMHxhOfscxPfIfm/giphy.gif' },
            reloj: { nombre: 'Reloj', emoji: '⏰', url: 'https://media.giphy.com/media/3o7TKTDn976rzVgky4/giphy.gif' },
            cohete: { nombre: 'Cohete', emoji: '🚀', url: 'https://media.giphy.com/media/mi6DsSSNKDbUY/giphy.gif' },
            alerta: { nombre: 'Alerta', emoji: '⚠️', url: 'https://media.giphy.com/media/fRhSHzQ4NXOdrHIZJd/giphy.gif' },
            bienvenida: { nombre: 'Bienvenida', emoji: '👋', url: 'https://media.giphy.com/media/dzaUX7CAG0Ihi/giphy.gif' },
            gracias: { nombre: 'Gracias', emoji: '🙏', url: 'https://media.giphy.com/media/osjgQPWRx3cac/giphy.gif' }
        },
        showReiniciarModal: false,
        showCountdown: false,

        init() {
            this.setupWebSocket();
            if (this.sorteoActivo) this.startAutoPlay();
        },

        setupWebSocket() {
            if (typeof window.Echo === 'undefined') return;
            window.Echo.channel('juego.' + this.juegoId)
                .listen('.juego.actualizado', (e) => {
                    this.acumulado = e.acumulado;
                    this.premioLinea = e.premioLinea;
                    this.premioBingo = e.premioBingo;
                    this.totalCartones = e.totalCartones || this.totalCartones;
                    this.totalJugadores = e.totalJugadores || this.totalJugadores;
                    if (e.jugadores) this.jugadores = e.jugadores;
                })
                .listen('.jugador.salio', (e) => {
                    this.totalJugadores = e.totalJugadores;
                    this.totalCartones = e.totalCartones;
                    this.jugadores = this.jugadores.filter(j => j.nombre !== e.nombreJugador);
                    this.mostrarNotificacion('👋 ' + e.nombreJugador + ' salió', 'alerta');
                });
        },

        async sortearBola() {
            if (this.isDrawing) return;
            this.isDrawing = true;
            try {
                const response = await fetch('/admin/sortear/' + this.juegoId, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }
                });
                const data = await response.json();
                if (data.error) {
                    if (data.finalizado) { this.estado = 'finalizado'; this.sorteoActivo = false; this.stopAutoPlay(); }
                    this.isDrawing = false;
                    return;
                }
                this.ultimaBola = data.bola;
                this.bolasSorteadas = data.bolas_sorteadas;
                this.historial.unshift(data.bola);
                if (this.historial.length > 12) this.historial.pop();
                if (data.ganador_linea) this.mostrarNotificacion('🎯 ' + data.ganador_linea.nombre + ' ganó LÍNEA!', 'exito');
                if (data.ganador_bingo) { this.mostrarNotificacion('🏆 ' + data.ganador_bingo.nombre + ' ganó BINGO!', 'exito'); this.estado = 'finalizado'; this.sorteoActivo = false; this.stopAutoPlay(); }
                if (data.finalizado) { this.estado = 'finalizado'; this.sorteoActivo = false; this.stopAutoPlay(); }
            } catch (error) { console.error('Error:', error); }
            finally { this.isDrawing = false; }
        },

        async toggleSorteoAuto() {
            if (this.sorteoActivo) await this.detenerSorteo();
            else await this.iniciarSorteo();
        },

        async iniciarSorteo() {
            try {
                const response = await fetch('/admin/iniciar-sorteo/' + this.juegoId, {
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }
                });
                const data = await response.json();
                if (data.success) {
                    this.iniciarConteoRegresivo(() => {
                        this.sorteoActivo = true;
                        this.estado = 'en_curso';
                        this.startAutoPlay();
                    });
                }
            } catch (error) { console.error('Error:', error); }
        },

        iniciarConteoRegresivo(callback) {
            this.showCountdown = true;
            setTimeout(() => {
                this.showCountdown = false;
                if (callback) callback();
            }, 1500);
        },

        async detenerSorteo() {
            try {
                const response = await fetch('/admin/detener-sorteo/' + this.juegoId, {
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }
                });
                const data = await response.json();
                if (data.success) { this.sorteoActivo = false; this.stopAutoPlay(); }
            } catch (error) { console.error('Error:', error); }
        },

        startAutoPlay() {
            if (this.autoPlayInterval) return;
            this.autoPlayInterval = setInterval(() => {
                if (!this.isDrawing && this.estado !== 'finalizado') this.sortearBola();
            }, 4500);
        },

        stopAutoPlay() {
            if (this.autoPlayInterval) { clearInterval(this.autoPlayInterval); this.autoPlayInterval = null; }
        },

        async enviarMensaje() {
            if (!this.mensaje.trim()) return;
            try {
                await fetch('/admin/mensaje/' + this.juegoId, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content },
                    body: JSON.stringify({ mensaje: this.mensaje, tipo: this.tipoMensaje, gif: this.gifSeleccionado })
                });
                this.mostrarNotificacion('✅ Mensaje enviado', 'exito');
                this.mensaje = '';
                this.gifSeleccionado = null;
                this.gifCustom = '';
                this.showGifCustomInput = false;
            } catch (error) { console.error('Error:', error); }
        },

        cargarMensaje(texto, tipo, gifKey) {
            this.mensaje = texto;
            this.tipoMensaje = tipo || 'info';
            this.gifSeleccionado = gifKey && this.gifsDisponibles[gifKey] ? this.gifsDisponibles[gifKey].url : null;
            this.$refs.mensajeInput.focus();
        },

        async confirmarReinicio() {
            this.showReiniciarModal = false;
            try {
                const response = await fetch('/admin/reiniciar/' + this.juegoId, {
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }
                });
                const data = await response.json();
                if (data.success) {
                    this.mostrarNotificacion('✅ Juego reiniciado', 'exito');
                    setTimeout(() => window.location.reload(), 1000);
                }
            } catch (error) { console.error('Error:', error); }
        },

        mostrarNotificacion(mensaje, tipo) {
            const colores = { info: 'bg-blue-500', alerta: 'bg-yellow-500', exito: 'bg-green-500', error: 'bg-red-500' };
            const notif = document.createElement('div');
            notif.className = 'fixed top-20 right-4 z-50 px-4 py-3 rounded-xl ' + (colores[tipo] || 'bg-blue-500') + ' text-white font-semibold text-sm shadow-lg';
            notif.textContent = mensaje;
            document.body.appendChild(notif);
            setTimeout(() => notif.remove(), 3000);
        },

        async cambiarMaxBolas(cantidad) {
            if (this.estado === 'en_curso') {
                this.mostrarNotificacion('⚠️ No puedes cambiar durante el sorteo', 'alerta');
                return;
            }
            if (this.maxBolas == cantidad) return;
            
            try {
                const response = await fetch('/admin/max-bolas/' + this.juegoId, {
                    method: 'POST',
                    headers: { 
                        'Content-Type': 'application/json', 
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ max_bolas: cantidad })
                });
                
                const data = await response.json();
                if (data.success) {
                    this.maxBolas = data.max_bolas;
                    this.mostrarNotificacion('✅ Configurado a ' + cantidad + ' bolas', 'exito');
                } else if (data.error) {
                    this.mostrarNotificacion('❌ ' + data.error, 'error');
                }
            } catch (error) { 
                console.error('Error:', error);
                this.mostrarNotificacion('❌ Error de conexión', 'error');
            }
        }
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/arzabala/Documents/proyecto/bingo-electronico/resources/views/admin/panel.blade.php ENDPATH**/ ?>